<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Paragraph extends Model 
{

    protected $table = 'paragraphs';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function language()
    {
        return $this->hasOne('Languages');
    }

    public function section()
    {
        return $this->hasOne('Section');
    }

    public function paragraphType()
    {
        return $this->hasOne('ParagraphType');
    }

}